/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterendisland.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ObsidianProcessor
extends StructureProcessor {
    public static final Codec<ObsidianProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("number_times_dragon_killed").forGetter(config -> config.numberTimesDragonKilled)).apply((Applicative)instance, instance.stable(ObsidianProcessor::new)));
    private final int numberTimesDragonKilled;

    public ObsidianProcessor(int numberTimesDragonKilled) {
        this.numberTimesDragonKilled = numberTimesDragonKilled;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.f_74676_.m_60713_(Blocks.f_50080_)) {
            RandomSource random = structurePlacementData.m_230326_(blockInfoGlobal.f_74675_);
            BlockState outputState = Blocks.f_50080_.m_49966_();
            int dragonKills = Mth.m_14045_((int)this.numberTimesDragonKilled, (int)0, (int)10);
            float cryingChance = Mth.m_14179_((float)((float)dragonKills / 10.0f), (float)0.0f, (float)0.5f);
            if (random.m_188501_() < cryingChance) {
                outputState = Blocks.f_50723_.m_49966_();
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_, outputState, blockInfoGlobal.f_74677_);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return StructureProcessorTypeModule.OBSIDIAN_PROCESSOR;
    }
}

